<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['run'])) {
    $run = trim($_POST['run']);

    $db = new conexion();
    $conn = $db->conectar();

    $stmt = $conn->prepare("SELECT COUNT(*) FROM estudiantes WHERE Id_Estudiantes = ?");
    $stmt->bind_param("s", $run);
    $stmt->execute();
    $stmt->bind_result($count);
    $stmt->fetch();
    $stmt->close();

    $existe = $count > 0;

    header('Content-Type: application/json');
    echo json_encode(['exists' => $existe]);
    exit;
}

http_response_code(400);
header('Content-Type: application/json');
echo json_encode(['error' => 'Solicitud inválida']);
