<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Listado de Asignaturas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4Q6Gf2aSP4eDXB8Miphtr37CMZZQ5oXLH2yaXMJ2w8e2ZtHTl7GptT4jmndRuHDT" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js" integrity="sha384-j1CDi7MgGQ12Z7Qab0qlWQ/Qqz24Gc6BM0thvEMVjHnfYGF0rmFCozFSxQBxwHKO" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="../estilos.css">
    <link rel="stylesheet" href="../fuentes.css">
    <link rel="shortcut icon" href="../favicon.ico" type="image/x-icon">
</head>
<body>
    <?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>

<?php 
include'../routes/conexion.php';
$bs=new conexion();
$bs->sql = "SELECT a.Id_Asignatura, a.Nombre_Asignatura, a.Estado_Asig FROM asignatura a WHERE a.Estado_Asig = 1;";
$bs->res=mysqli_query($bs->conector,$bs->sql);
$res = $bs->res;
$contador=0;

$sqlConsultaAsignaturas = "SELECT a.Id_Asignatura, a.Nombre_Asignatura, a.Estado_Asig FROM asignatura a WHERE a.Estado_Asig = 2;";
$resAsignaturasDesactivadas = mysqli_query($bs->conector, $sqlConsultaAsignaturas);


$totalAsignaturas = 0;
$sqlContador = "SELECT COUNT(*) as total FROM Asignatura";
$resultadoContador = mysqli_query($bs->conector, $sqlContador);
if ($resultadoContador && mysqli_num_rows($resultadoContador) > 0) {
    $fila = mysqli_fetch_assoc($resultadoContador);
    $totalAsignaturas = $fila['total'];
}

$totalAsignaturasDesactivadas = 0;
$sqlContadorAsigDesactivadas = "SELECT COUNT(*) as total FROM asignatura WHERE Estado_Asig = 2 AND Id_Asignatura IS NOT NULL;";
$resultadoAsigContadorDesactivados = mysqli_query($bs->conector, $sqlContadorAsigDesactivadas);
if ($resultadoAsigContadorDesactivados && mysqli_num_rows($resultadoAsigContadorDesactivados) > 0) {
    $fila = mysqli_fetch_assoc($resultadoAsigContadorDesactivados);
    $totalAsignaturasDesactivadas = $fila['total'];
}

$totalAsignaturasActivas = 0;
$sqlContadorAsigActivas = "SELECT COUNT(*) as total FROM asignatura WHERE Estado_Asig = 1 AND Id_Asignatura IS NOT NULL;";
$resultadoAsigContadorActivo = mysqli_query($bs->conector, $sqlContadorAsigActivas);
if ($resultadoAsigContadorActivo && mysqli_num_rows($resultadoAsigContadorActivo) > 0) {
    $fila = mysqli_fetch_assoc($resultadoAsigContadorActivo);
    $totalAsignaturasActivas = $fila['total'];
}
 ?>

    <div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php" style="margin-left: 30px; display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">home</span></a>
                <a class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#staticBackdrop" data-bs-custom-class="custom-tooltip" data-bs-toggle="tooltip" data-bs-placement="top" title="Activacion de Asignaturas" style="margin-left: 10px; display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">widgets</span></a>
                <script>
                const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
                const tooltipList = [...tooltipTriggerList].map(el => new bootstrap.Tooltip(el));
            </script>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel" style="height: 470px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    <a href="../views/registrarAsignatura.php" class="btn btn-primary "
                        style="margin-left: 50px;margin-right: 50px;"><span class="material-symbols-outlined">bookmark_add</span>Agregar Nueva Asignatura</a>
                    
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminmantenedor.php">
                                                <span class="material-symbols-outlined">rule_settings</span> Mantenedores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/reportes/vistaadminreportes.php">
                                                <span class="material-symbols-outlined">breaking_news</span> Reportes
                                            </a>
                                        </li>
                                        <div class="col"></div>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;width: 181px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <br><br><br><br><br><br>
    <div class="encode-sans" style=": rgb(37, 84, 157);">
        <h3>
            <center>📊 <strong>LISTADO DE ASIGNATURAS</strong></center>
        </h3>
    </div>
    <div class="container text-center" style="margin-left: 100px;margin-right: 20px;">
  <div class="row">
    <div class="col" style="width: 200px;">
      <div class="card shadow rounded-4 border-0"
            style="background: linear-gradient(135deg, #4A90E2, #007BFF);color: white;width: 350px;margin-left: 80px;">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                        book
                    </span>
                </div>
                <div>
                    <h6 class="mb-0" style="opacity: 0.8;">N° Total Asignaturas Inscritas</h6>
                    <h2 class="fw-bold"><?php echo $totalAsignaturas; ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col" style="width: 200px;">
      <div class="card shadow rounded-4 border-0"
            style="background: linear-gradient(135deg,rgb(13, 169, 57),rgb(48, 136, 16));color: white;width: 350px;margin-left: 80px;">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                        book_5
                    </span>
                </div>
                <div>
                    <h6 class="mb-0" style="opacity: 0.8;">N° Asignaturas Activas</h6>
                    <h2 class="fw-bold"><?php echo $totalAsignaturasActivas; ?></h2>
                </div>
            </div>
        </div>
    </div>
    <div class="col" style="width: 200px;">
      <div class="card shadow rounded-4 border-0"
            style="background: linear-gradient(135deg,rgb(226, 74, 74),rgb(255, 0, 0));color: white;width: 350px;margin-left: 80px;">
            <div class="card-body d-flex align-items-center">
                <div class="me-3">
                    <span class="material-symbols-outlined" style="font-size: 50px; animation: pulse 1.5s infinite;">
                        bookmark_remove
                    </span>
                </div>
                <div>
                    <h6 class="mb-0" style="opacity: 0.8;">N° Total Asignaturas Inactivas</h6>
                    <h2 class="fw-bold"><?php echo $totalAsignaturasDesactivadas; ?></h2>
                </div>
            </div>
        </div>
    </div>
  </div>
</div>
    <br><br>
    <input type="text" id="buscadorAsignaturas" class="form-control" placeholder="Buscar asignatura..." style="width: 326.5px; margin-left: 200px; margin-bottom: 10px;">
<div class="container mb-4">
    <div class="table-responsive">
        <table class="table table-hover align-middle">
            <thead class="table-primary">
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Nombre Asignatura</th>
                    <th scope="col">Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $contador = 0;
                while ($row = mysqli_fetch_assoc($res)) { ?>
                    <tr>
                        <td><?= htmlspecialchars($row['Id_Asignatura']) ?></td>
                        <td><?= htmlspecialchars($row['Nombre_Asignatura']) ?></td>
                        <td>
                            <form action="gestionar_asignatura.php" method="GET" style="display:inline;">
                                <input type="hidden" name="id" value="<?= $row['Id_Asignatura'] ?>">
                                <button type="submit" class="btn btn-primary">
                                    <span class="material-symbols-outlined" style="vertical-align: middle;">menu_book</span>
                                    Gestionar
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="staticBackdropLabel">Gestionar asignaturas desactivadas</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <table class="table">
  <thead>
    <tr>
      <th scope="col">#</th>
      <th scope="col">Nombre Asignatura</th>
      <th scope="col">Estado</th>
      <th scope="col"></th>
    </tr>
  </thead>
  <tbody>
    <?php 
if(mysqli_num_rows($resAsignaturasDesactivadas)>0){
    $contador = 0;
    while($persona = mysqli_fetch_row($resAsignaturasDesactivadas)){
        $contador++;
?>
    <tr>
        <td><?=$persona[0]?></td>
        <td><?=$persona[1]?></td>
        <td><?=$persona[2] == 2 ? 'Inactiva' : 'Activa'?></td>
        <td> 
            <div class="form-check form-switch">
                <input class="form-check-input toggle-estado" type="checkbox" data-id="<?=$persona[0]?>"
                <?= $persona[2] == 1 ? 'checked' : '' ?>>
            </div>
        </td>
    </tr>
<?php 
    } 
} else { 
    echo '<th colspan="9" class="alert alert-danger text-center">No existen asignaturas desactivadas actualmente.</th>';
}
?>
  </tbody>
</table>
      </div>
    </div>
  </div>
</div>

<div class="position-fixed top-0 end-0 p-3" style="z-index: 9999">
  <div id="toastExito" class="toast align-items-center text-bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body">
        ✅ La asignatura se activará en 3 segundos, por favor espere mientras se recarga la página para aplicar los cambios.
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const switches = document.querySelectorAll('.toggle-estado');
    switches.forEach(function (toggle) {
        toggle.addEventListener('change', function () {
            const idAsignatura = this.dataset.id;
            const nuevoEstado = this.checked ? 1 : 0;

            fetch('../routes/estado-asignaturas.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `id=${idAsignatura}&estado=${nuevoEstado}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Mostrar Toast
                    var toastEl = document.getElementById('toastExito');
                    var toast = new bootstrap.Toast(toastEl);
                    toast.show();
                    // Recargar después de 3 segundos
                    setTimeout(function() {
                        location.reload();
                    }, 4000);
                } else {
                    alert("Error al actualizar estado.");
                }
            })
            .catch(error => {
                console.error('Error al actualizar el estado:', error);
            });
        });
    });
});
</script>
<script>
    const myModal = document.getElementById('myModal')
    const myInput = document.getElementById('myInput')

    myModal.addEventListener('shown.bs.modal', () => {
    myInput.focus()
})
</script>
<script>
// Filtrado de asignaturas en la tabla
document.addEventListener('DOMContentLoaded', function () {
    const buscador = document.getElementById('buscadorAsignaturas');
    const tabla = document.querySelector('.table-responsive table');
    buscador.addEventListener('keyup', function () {
        const filtro = buscador.value.toLowerCase();
        const filas = tabla.tBodies[0].rows;
        for (let i = 0; i < filas.length; i++) {
            const nombre = filas[i].cells[1].textContent.toLowerCase();
            filas[i].style.display = nombre.includes(filtro) ? '' : 'none';
        }
    });
});
</script>
</body>
</html>