<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <title>Vista: Registrar Profesor</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Encode+Sans:wght@900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="../fuentes.css">
    <link rel="icon" href="../favicon.ico" type="image/x-icon">
</head>
<style>
            body {
            background-color: rgb(234, 236, 238);
        }

    .poppins-black {
        font-family: "Poppins", sans-serif;
        font-weight: 900;
        font-style: normal;
    }
</style>

<body>
<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>
<div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel" style="height: 400px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                    
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                        <br><br>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page" href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                    </div>
                                </div>
                            </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <br><br><br><br><br><br>

    <div class="encode-sans" style=": rgb(37, 84, 157);">
        <center>
            <h2><strong>📝 REGISTRO DE PROFESORES</strong></h2>
        </center>
    </div>
    <br>
    <form method="post" action="../routes/formu_profesores.php">
        <div class="formulario" style="margin-left: 30%; margin-right: 30%">
            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="run" name="id_profesores" maxlength="10" required title="Ingrese solo números y la letra K (sin puntos ni guión)">
                <label for="floatingInput">RUN</label>
            </div>
            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="nombre" name="nombre_fun" pattern="[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+" required title="Ingrese solo letras (sin números ni símbolos)">
                <label for="floatingInput">Primer/Segundo Nombre del Profesor/a</label>
            </div>
            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="apellido" name="apellido_fun" pattern="[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+" required title="Ingrese solo letras (sin números ni símbolos)">
                <label for="floatingInput">Primer/Segundo Apellido del Profesor/a</label>
            </div>
            <div class="form-floating mb-3">
                <input type="email" class="form-control" id="email" name="email_fun" required title="Ingrese un correo electrónico válido">
                <label for="floatingInput">Correo Electronico</label>
            </div>
            <div class="form-floating mb-3">
                <input type="password" class="form-control" id="password" name="password" placeholder="name@example.com">
                <label for="floatingInput">Contraseña (Max. 80 Caracteres)</label>
            </div>
            <div class="form-floating mb-3">
                <input type="text" class="form-control" maxlength="9" id="telefono" name="telefono" pattern="\d{9}" required title="Ingrese solo 9 dígitos numéricos">
                <label for="floatingInput">Telefono (+56)</label>
            </div>
            <center><button type="submit" class="btn btn-success">✅ Registrar Docente</button></center>
            <?php
if (isset($_SESSION['mensaje'])) {
    $mensaje = $_SESSION['mensaje'];

    if ($mensaje === "incompleto") {
        echo '
        <div class="toast-container position-fixed bottom-0 end-0 p-3">
            <div class="toast text-bg-warning show">
                <div class="toast-body">⚠️ Debes completar todos los campos.</div>
            </div>
        </div>';
    } elseif ($mensaje === "duplicado") {
        echo '
        <div class="toast-container position-fixed bottom-0 end-0 p-3">
            <div class="toast text-bg-danger show">
                <div class="toast-body">❌ El RUN ingresado ya existe.</div>
            </div>
        </div>';
    } elseif ($mensaje === "exito") {
        echo '
        <div class="toast-container position-fixed bottom-0 end-0 p-3">
            <div class="toast text-bg-success show">
                <div class="toast-body">✅ Profesor registrado correctamente.</div>
            </div>
        </div>';
    } elseif ($mensaje === "error") {
        echo '
        <div class="toast-container position-fixed bottom-0 end-0 p-3">
            <div class="toast text-bg-danger show">
                <div class="toast-body">❌ Error al registrar el profesor en la base de datos.</div>
            </div>
        </div>';
    }

    unset($_SESSION['mensaje']);
}
?>
        </div>
    </form>
    <script>
    const toastElList = [].slice.call(document.querySelectorAll('.toast'));
    toastElList.forEach(function (toastEl) {
        new bootstrap.Toast(toastEl).show();
    });
</script>
    <script>
document.querySelector('form').addEventListener('submit', function (e) {
    const run = document.getElementById('run').value;
    const nombre = document.getElementById('nombre').value;
    const apellido = document.getElementById('apellido').value;
    const email = document.getElementById('email').value;
    const telefono = document.getElementById('telefono').value;

    const soloLetras = /^[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+$/;
    const soloNumeros = /^\d+$/;
    const correoValido = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    const runValido = /^[0-9]{7,8}[0-9K]$/;

    if (!runValido.test(run)) {
        alert("El RUN debe tener entre 8 y 9 dígitos más un dígito verificador (número o K). No use puntos ni guión.");
        e.preventDefault();
    } else if (!soloLetras.test(nombre)) {
        alert("El campo Nombre solo debe contener letras.");
        e.preventDefault();
    } else if (!soloLetras.test(apellido)) {
        alert("El campo Apellido solo debe contener letras.");
        e.preventDefault();
    } else if (!correoValido.test(email)) {
        alert("Ingrese un correo electrónico válido.");
        e.preventDefault();
    } else if (!soloNumeros.test(telefono) || telefono.length !== 9) {
        alert("El teléfono debe contener exactamente 9 números.");
        e.preventDefault();
    }
});
</script>
<script>
// Solo permite números y la letra K, convierte "k" a "K"
document.getElementById('run').addEventListener('input', function (e) {
    let valor = e.target.value.toUpperCase().replace(/[^0-9K]/g, '');
    e.target.value = valor;
});
</script>

</body>

</html>