<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <title>Inscripción de Estudiantes</title>
    <link rel="icon" href="../favicon.ico" type="image/x-icon">
    <link rel="stylesheet" href="../fuentes.css">
</head>
<style>
            body {
            background-color: rgb(234, 236, 238);
        }

    .poppins-black {
        font-family: "Poppins", sans-serif;
        font-weight: 900;
        font-style: normal;
    }
</style>

<body>
<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
$nombreUsuario = $_SESSION['profesor'];
?>
<div class="navbar">
        <nav class="navbar fixed-top">
            <div class="container-fluid p-4 d-flex justify-content-between" style="width: 248px;margin-left: 10px;">

                <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas"
                    data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar" aria-label="Toggle navigation"
                    style="margin-left: 2px;">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <a class="btn btn-outline-danger" aria-current="page" href="/CasaAzul/views/vistaadmin.php"
                    style="display: flex; justify-content: flex-end;"><span
                        class="material-symbols-outlined">home</span></a>
                <a class="btn btn-secondary" aria-current="page" href="/CasaAzul/views/vistaadminestudiantes.php" style="display: flex; justify-content: flex-end;"><span class="material-symbols-outlined">reply</span></a>
                <a class="navbar-brand" href="#"></a>

                <div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel" style="height: 400px;border-radius: 8px;">
                    <div class="offcanvas-header">
                        <div class="encode-sans" style=": rgb(37, 84, 157);">
                            <h5 class="offcanvas-title" id="offcanvasNavbarLabel">📍Menú Rapido</h5>
                        </div>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                    </div>
                    <br>
                
                    <div class="offcanvas-body">
                        <ul class="navbar-nav justify-content-end flex-grow-1 pe-3">
                            <div class="container text-center">
                                <div class="row align-items-start">
                                    <div class="col">
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminprofes.php">
                                                <span class="material-symbols-outlined">school</span> Profesores
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary disabled"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadminestudiantes.php">
                                                <span class="material-symbols-outlined">people</span> Estudiantes
                                            </a>
                                        </li>
                                        <br><br>
                                        <li class="nav-item btn btn-danger"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" href="/CasaAzul/routes/logout.php">
                                                <span class="material-symbols-outlined">logout</span> Cerrar sesión
                                            </a>
                                        </li>
                                    </div>
                                    <div class="col">
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page" href="/CasaAzul/views/vistaadminasignaturas.php">
                                                <span class="material-symbols-outlined">fact_check</span> Asignaturas
                                            </a>
                                        </li>
                                        <li class="nav-item btn btn-outline-secondary"
                                            style="margin-bottom: 10px;padding-bottom: 0px;padding-top: 0px;width: 151px;">
                                            <a class="nav-link active" aria-current="page"
                                                href="/CasaAzul/views/vistaadmincursos.php">
                                                <span class="material-symbols-outlined">class</span> Cursos
                                            </a>
                                        </li>
                                    </div>
                                </div>
                            </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </nav>
    </div>
    <br><br><br>

    <div class="encode-sans">
        <center>
            <h3><strong>📝 REGISTRO DE ESTUDIANTES</strong></h3>
        </center>
    </div>
    <br>
    <form method="post" action="../routes/formu_estudiantes.php">
        <div class="formulario" style="margin-left: 30%; margin-right: 30%">

            <div class="form-floating mb-3">
              <input type="text" class="form-control" id="run" name="id_estudiantes" placeholder="Ej: 12345678K" minlength="8" maxlength="9" title="Debe contener 7 u 8 dígitos y un dígito verificador (puede ser K)" required>
              <label for="run">RUN</label>
            </div>

            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="nombre" name="nombre_est" placeholder="Patricia" pattern="^[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+$" title="Solo letras y espacios" required>
                <label for="floatingInput">Nombres</label>
            </div>
            <div class="form-floating mb-3">
                <input type="text" class="form-control" id="apellido" name="apellido_est" placeholder="Muñoz" pattern="^[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+$" title="Solo letras y espacios" required>
                <label for="floatingInput">Apellidos</label>
            </div>
            <div class="form-floating mb-3">
                <input type="email" class="form-control" id="email" name="email_est" placeholder="name@example.com" pattern="^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$" title="Debe ser un correo válido, ejemplo: nombre@dominio.com" required>
                <label for="floatingInput">Correo Electronico</label>
            </div>
            <div class="form-floating mb-3">
    <input type="text" class="form-control" maxlength="9" id="telefono_fijo" name="telefono_fijo_est"
        placeholder="212345678" pattern="^2\d{8}$" title="Debe comenzar con 2 y tener 9 dígitos" required>
    <label for="telefono_fijo">Teléfono Fijo (+56)</label>
</div>
            <div class="form-floating mb-3">
    <input type="text" class="form-control" maxlength="9" id="telefono" name="telefono_movil_est"
        placeholder="912345678" pattern="^9\d{8}$" title="Debe comenzar con 9 y tener 9 dígitos" required>
    <label for="telefono">Teléfono Móvil (+56)</label>
</div>
            <center><button type="button" class="btn btn-success" onclick="mostrarToastYEnviar()">✅ Registrar y Asignar Curso</button><a href="/CasaAzul/views/insertAlumnoCurso.php" class="btn btn-outline-danger" style="border-left-width: 1px;margin-left: 12px;">⛔ Descartar cambios y volver</a></center></center>
            <!-- TOAST Success -->
<div class="position-fixed bottom-0 end-0 p-3" style="z-index: 11">
  <div id="toastSuccess" class="toast align-items-center text-white bg-success border-0" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="d-flex">
      <div class="toast-body">
        ✅ Estudiante registrado exitosamente.
        Serás redirigido a la página de asignación de curso en 5 segundos.
      </div>
      <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
  </div>
</div>

            <br><br>
        </div>
    </form>
<script>
function validarRun(run) {
  return /^[0-9]{7,8}[0-9K]$/.test(run); // Ej: 12345678K o 1234567K
}
function validarTelefonoFijo(tel) {
  return /^2\d{8}$/.test(tel);
}
function validarTelefonoMovil(tel) {
  return /^9\d{8}$/.test(tel);
}
function validarEmail(email) {
  return /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/.test(email);
}
function limpiarRun(run) {
  return run.toUpperCase().replace(/[^0-9K]/g, '');
}

async function mostrarToastYEnviar() {
  console.log('👉 Función mostrarToastYEnviar ejecutada'); // DEBUG

  const runInput = document.getElementById('run');
  const telFijoInput = document.getElementById('telefono_fijo');
  const telMovilInput = document.getElementById('telefono');
  const emailInput = document.getElementById('email');
  const nombreInput = document.getElementById('nombre');
  const apellidoInput = document.getElementById('apellido');

  const runLimpio = limpiarRun(runInput.value);
  if (!validarRun(runLimpio)) {
    alert('❌ El RUN debe tener el formato 00123456-7');
    runInput.classList.add('is-invalid');
    return;
  }

  if (!validarTelefonoFijo(telFijoInput.value)) {
    alert('❌ El teléfono fijo debe comenzar con 2 y tener 9 dígitos.');
    telFijoInput.classList.add('is-invalid');
    return;
  }

  if (!validarTelefonoMovil(telMovilInput.value)) {
    alert('❌ El teléfono móvil debe comenzar con 9 y tener 9 dígitos.');
    telMovilInput.classList.add('is-invalid');
    return;
  }

  if (!validarEmail(emailInput.value)) {
    alert('❌ Debe ingresar un correo válido.');
    emailInput.classList.add('is-invalid');
    return;
  }

  if (!validarNombreOApellido(nombreInput.value)) {
  alert('❌ El campo "Nombres" solo debe contener letras y espacios.');
  nombreInput.classList.add('is-invalid');
  nombreInput.focus();
  return;
} else {
  nombreInput.classList.remove('is-invalid');
}

if (!validarNombreOApellido(apellidoInput.value)) {
  alert('❌ El campo "Apellidos" solo debe contener letras y espacios.');
  apellidoInput.classList.add('is-invalid');
  apellidoInput.focus();
  return;
} else {
  apellidoInput.classList.remove('is-invalid');
}

  function validarNombreOApellido(texto) {
  return /^[A-Za-zÁÉÍÓÚáéíóúÑñ\s]+$/.test(texto.trim());
}


  try {
    const response = await fetch('../routes/verificar_run.php', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: 'run=' + encodeURIComponent(runLimpio)
    });

    const data = await response.json();

    if (data.exists) {
      alert('❌ Ya existe un estudiante registrado con este RUN.');
      runInput.classList.add('is-invalid');
      return;
    }

    // Todo bien, mostramos toast y enviamos
    const toastElement = document.getElementById('toastSuccess');
    const toast = new bootstrap.Toast(toastElement);
    toast.show();

    setTimeout(() => {
      document.querySelector('form').submit();
    }, 5000);

  } catch (error) {
    console.error('❌ Error en la verificación de RUN:', error);
    alert('Hubo un error al verificar el RUN. Intenta nuevamente.');
  }
  
}
</script>

<script>
document.getElementById('run').addEventListener('input', function (e) {
  const valor = e.target.value.toUpperCase().replace(/[^0-9K]/g, '');
  e.target.value = valor;
});
</script>

</body>

</html>