<?php
session_start();
include_once __DIR__ . '/../../routes/conexion.php';

$db = new conexion();
$conn = $db->conectar();

$log_dir = __DIR__ . '/../../routes/logs';
$log_file = $log_dir . '/asistencia.log';

if (!file_exists($log_dir)) {
    mkdir($log_dir, 0777, true);
}

function escribir_log($mensaje, $log_file) {
    $fecha = date('Y-m-d H:i:s');
    file_put_contents($log_file, "[$fecha] $mensaje" . PHP_EOL, FILE_APPEND);
}

if (!isset($_SESSION['profesor'])) {
    die("Acceso no autorizado. No se encontró la sesión del profesor.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['asistencia'])) {
    $asistencias = $_POST['asistencia'];
    $fecha = $_POST['fecha'];

    foreach ($asistencias as $id_estudiante => $estado) {
        if ($estado === "") continue;

        // Validar si ya existe el registro
        $check_stmt = $conn->prepare("SELECT COUNT(*) FROM asistencia WHERE Id_Estudiantes = ? AND fecha = ?");
        $check_stmt->bind_param("is", $id_estudiante, $fecha);
        $check_stmt->execute();
        $check_stmt->bind_result($count);
        $check_stmt->fetch();
        $check_stmt->close();

        if ($count > 0) {
            // Actualizar
            $update_stmt = $conn->prepare("UPDATE asistencia SET Id_EstadoAsist = ? WHERE Id_Estudiantes = ? AND fecha = ?");
            $update_stmt->bind_param("iis", $estado, $id_estudiante, $fecha);
            $update_stmt->execute();
            $update_stmt->close();
            escribir_log("Actualización: Estudiante $id_estudiante, Estado $estado, Fecha $fecha", $log_file);
        } else {
            // Insertar
            $insert_stmt = $conn->prepare("INSERT INTO asistencia (Id_Estudiantes, Id_EstadoAsist, fecha) VALUES (?, ?, ?)");
            $insert_stmt->bind_param("iis", $id_estudiante, $estado, $fecha);
            $insert_stmt->execute();
            $insert_stmt->close();
            escribir_log("Inserción: Estudiante $id_estudiante, Estado $estado, Fecha $fecha", $log_file);
        }
    }

    $conn->close();

    header("Location: ../../views/asistenciaCursos/asistSextobas.php");
    exit;
} else {
    echo "Acceso inválido.";
}
