<?php
session_start();
if (!isset($_SESSION['profesor'])) {
    header("Location: login.php");
    exit();
}
if (!isset($_POST['nivel']) || !isset($_POST['curso'])) {
    die("Parámetros faltantes.");
}
$nivel = intval($_POST['nivel']);
$curso = intval($_POST['curso']);

include '../routes/conexion.php';
$bs = new conexion();
$conn = $bs->conectar();

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=reporte_asistencia_curso.xls");
echo "RUT\tNombre\tDias Presentes\tDias Ausentes\tTotal Registros\t% Asistencia\n";

$sqlEstudiantes = "SELECT e.Id_Estudiantes, e.Nombre_Est, e.Apellido_Est
                   FROM estudiantes e
                   JOIN matricula m ON e.Id_Estudiantes = m.Id_EstudiantesMat
                   WHERE m.Id_NivelesMat = ? AND m.Id_CursosMat = ? AND e.Id_EstadoEst = 1";
$stmtEst = $conn->prepare($sqlEstudiantes);
$stmtEst->bind_param("ii", $nivel, $curso);
$stmtEst->execute();
$resEst = $stmtEst->get_result();

while ($est = $resEst->fetch_assoc()) {
    $idEst = $est['Id_Estudiantes'];
    $sqlAsist = "SELECT Id_EstadoAsist FROM asistencia WHERE Id_Estudiantes = ?";
    $stmtAsist = $conn->prepare($sqlAsist);
    $stmtAsist->bind_param("i", $idEst);
    $stmtAsist->execute();
    $resAsist = $stmtAsist->get_result();

    $presentes = 0;
    $ausentes = 0;
    $total = 0;
    while ($row = $resAsist->fetch_assoc()) {
        if ($row['Id_EstadoAsist'] == 1) $presentes++;
        else $ausentes++;
        $total++;
    }
    $porcentaje = $total > 0 ? round(($presentes / $total) * 100, 2) : 0;
    echo $est['Id_Estudiantes'] . "\t" . $est['Nombre_Est'] . " " . $est['Apellido_Est'] . "\t" . $presentes . "\t" . $ausentes . "\t" . $total . "\t" . $porcentaje . "%\n";
    $stmtAsist->close();
}
$stmtEst->close();
$conn->close();
exit;
?>