<?php
class Asistencia {
    private $conector;
    private $logFile;

    public function __construct($conexion) {
        $this->conector = $conexion->conector;
        $this->logFile = __DIR__ . '/logs/asistencia_errors.log'; // Ruta del archivo de log
    }

    private function logError($message) {
        // Asegura que el directorio de logs existe
        if (!is_dir(dirname($this->logFile))) {
            mkdir(dirname($this->logFile), 0777, true);
        }

        // Formato del mensaje de log
        $timestamp = date('Y-m-d H:i:s');
        file_put_contents($this->logFile, "[$timestamp] $message\n", FILE_APPEND);
    }

    public function listarEstudiantes($nivelId) {
        $sql = "SELECT e.Id_Estudiantes, e.Nombre_Est, e.Segundo_Nombre_Est, e.Apellido_Est 
                FROM estudiantes e 
                JOIN matricula m ON e.Id_Estudiantes = m.Id_EstudiantesMat 
                WHERE m.Id_NivelesMat = ?";
        $stmt = $this->conector->prepare($sql);
        if (!$stmt) {
            $this->logError("Error preparando SQL en listarEstudiantes: " . $this->conector->error);
            return [];
        }
        $stmt->bind_param("i", $nivelId);
        $stmt->execute();
        $result = $stmt->get_result();
        if (!$result) {
            $this->logError("Error ejecutando SQL en listarEstudiantes: " . $stmt->error);
            return [];
        }
        return $result->fetch_all(MYSQLI_ASSOC);
    }

    public function registrarAsistencia($estudianteId, $estado, $fecha) {
        $sql = "INSERT INTO asistencia (Id_Estudiantes, fecha, Status) VALUES (?, ?, ?)";
        $stmt = $this->conector->prepare($sql);
        if (!$stmt) {
            $this->logError("Error preparando SQL en registrarAsistencia: " . $this->conector->error);
            return false;
        }
        $stmt->bind_param("iss", $estudianteId, $fecha, $estado);

        if ($stmt->execute()) {
            return true;
        } else {
            $this->logError("Error ejecutando SQL en registrarAsistencia: Datos -> ID: $estudianteId, Fecha: $fecha, Estado: $estado. Error: " . $stmt->error);
            return false;
        }
    }

    public function registrarAsistenciasEnLote($asistencias, $fecha) {
        $this->conector->begin_transaction();
        try {
            foreach ($asistencias as $idEstudiante => $estado) {
                if (!$this->registrarAsistencia($idEstudiante, $estado, $fecha)) {
                    throw new Exception("Error al registrar asistencia para el estudiante ID $idEstudiante");
                }
            }
            $this->conector->commit();
            return true;
        } catch (Exception $e) {
            $this->logError("Error en la transacción de registrarAsistenciasEnLote: " . $e->getMessage());
            $this->conector->rollback();
            return false;
        }
    }
}
?>
