<?php
header('Content-Type: application/json');
include 'conexion.php';

$conexion = new conexion();

// Verifica el estado actual: ¿hay al menos un estudiante activo?
$sqlEstado = "SELECT COUNT(*) as activos FROM estudiantes WHERE Id_Estudiantes IS NOT NULL AND Id_EstadoEst = 1";
$resEstado = mysqli_query($conexion->conector, $sqlEstado);
$activos = 0;

if ($resEstado && $row = mysqli_fetch_assoc($resEstado)) {
    $activos = intval($row['activos']);
}

// Si hay al menos uno activo, se desactivan todos; si todos están desactivados, se activan todos
$nuevoEstado = ($activos > 0) ? 2 : 1;

// Actualiza el estado de todos los estudiantes
$sqlUpdate = "UPDATE estudiantes SET Id_EstadoEst = ? WHERE Id_Estudiantes IS NOT NULL";
$stmt = $conexion->conector->prepare($sqlUpdate);
$stmt->bind_param("i", $nuevoEstado);

if ($stmt->execute()) {
    echo json_encode([
        'success' => true,
        'message' => $nuevoEstado == 1 ? 'Todos los estudiantes han sido ACTIVADOS' : 'Todos los estudiantes han sido DESACTIVADOS'
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al actualizar estados']);
}

$stmt->close();
$conexion->conector->close();
?>
